
#include <windows.h>

LRESULT CALLBACK WinFunc(HWND, UINT, WPARAM, LPARAM);
char szWinName[] = "MyWindow";

typedef int (*TYPE_FUNC)(HWND, LPCTSTR, LPCTSTR, UINT);
TYPE_FUNC MessageFunc;

int WINAPI WinMain (HINSTANCE hThisInst, HINSTANCE hPrevInst, LPSTR lpszArgs, int nWinMode)
{
	MSG msg;
	WNDCLASSEX wcl;
	HWND hWnd;

	ZeroMemory (&wcl, sizeof (wcl));
	wcl.cbSize = sizeof (wcl);
	wcl.hInstance = hThisInst;
	wcl.lpszClassName = szWinName;
	wcl.lpfnWndProc = WinFunc;
	wcl.hIcon=LoadIcon (NULL, IDI_APPLICATION);
	wcl.hCursor=LoadCursor (NULL, IDC_ARROW);
	wcl.hbrBackground = (HBRUSH)(GetStockObject (WHITE_BRUSH));

	if (!RegisterClassEx (&wcl))
		return 0;

	hWnd = CreateWindow (szWinName, "Framework for Windows",
			WS_OVERLAPPEDWINDOW,
			10, 10, 320, 240,
			HWND_DESKTOP, NULL, hThisInst, NULL);

	ShowWindow (hWnd, nWinMode);
	UpdateWindow (hWnd);

	while (GetMessage (&msg, NULL, 0, 0)) {
			TranslateMessage (&msg);
			DispatchMessage (&msg);
	}

	return msg.wParam;
}

LRESULT CALLBACK WinFunc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) {
		case WM_CREATE:
			MessageFunc = (TYPE_FUNC) GetProcAddress(LoadLibrary("USER32.dll"), "MessageBoxA");
			break;
		case WM_CLOSE:
			if ( (*MessageFunc)  (hwnd, "Exit the application?", "Are You Shure?", MB_YESNO) == IDYES ) {
//			if ( MessageBox  (hwnd, "Exit the application?", "Are You Shure?", MB_YESNO) == IDYES ) {
				return DefWindowProc (hwnd, message, wParam, lParam);
			}
			break;
		case WM_DESTROY:
			PostQuitMessage (0);
			break;
		default:
			return DefWindowProc (hwnd, message, wParam, lParam);
	}
	return 0;
}
